unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, StdCtrls, Grids, Menus, ImgList, Spin,
  Buttons, Report01, MainData, GridEditor01, AprroxCentr01, ShowGraph01,
  ImportDialog01, About;

// ==========================================================
//    PROJECT
// ==========================================================
type
  TFormMain = class(TForm)
    PageControl1: TPageControl;
    TabSheetEdit: TTabSheet;
    TabSheetSeries: TTabSheet;
    TabSheetSpectr: TTabSheet;
    TabSheetBasis: TTabSheet;
    TabSheetReport: TTabSheet;
    PanelFunction: TPanel;
    PanelSpectr: TPanel;
    PanelBasis: TPanel;
    SGEditor1: TStringGrid;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    ColorDialog1: TColorDialog;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    Memo1: TMemo;
    StatusBar1: TStatusBar;
    ImageList16x16: TImageList;
    EdProjectDesc: TEdit;
    N9: TMenuItem;
    N10: TMenuItem;
    PopupMenuSGEditor: TPopupMenu;
    N11: TMenuItem;
    N12: TMenuItem;
    N13: TMenuItem;
    N16: TMenuItem;
    N17: TMenuItem;
    N14: TMenuItem;
    N15: TMenuItem;
    STextNeedSort: TStaticText;
    LabelNeedSortFlag: TLabel;
    Bevel1: TBevel;
    N18: TMenuItem;
    N19: TMenuItem;
    STxtCLampTFunc: TStaticText;
    BtnShowTFunc: TButton;
    CBoxFuncSScript: TComboBox;
    LViewBasis: TListView;
    BtnBasisClean: TButton;
    CBoxAproxSelect: TComboBox;
    Label1: TLabel;
    STxtCLamp1Aprox: TStaticText;
    BtnRunAprox: TButton;
    EdAproxMaxInd: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    STxtCLamp2Aprox: TStaticText;
    BtnShowAprox: TButton;
    BtnGraphClean: TButton;
    BtnSaveFuncAsJPEG: TButton;
    N20: TMenuItem;
    N21: TMenuItem;
    N22: TMenuItem;
    N23: TMenuItem;
    N24: TMenuItem;
    N25: TMenuItem;
    N26: TMenuItem;
    N27: TMenuItem;
    N28: TMenuItem;
    N30: TMenuItem;
    N31: TMenuItem;
    N32: TMenuItem;
    N33: TMenuItem;
    N34: TMenuItem;
    BtnReportClean: TButton;
    BtnSaveReportAsTxt: TButton;
    BtnSaveSpectrAsJPEG: TButton;
    CBoxSpectrSScript: TComboBox;
    BtnSpectrClean: TButton;
    BtnSpecrtRefresh: TButton;
    BtnShowBasis: TButton;
    BtnSaveBasisAsJPEG: TButton;
    Label5: TLabel;
    STxtLampBasis: TStaticText;
    BtnShowAllPoint: TButton;
    BtnShowAllBasis: TButton;
    N35: TMenuItem;
    BitBtnExportSpectr: TBitBtn;
    Panel1: TPanel;
    Label4: TLabel;
    STxtTermSeries: TStaticText;
    Label3: TLabel;
    SG01AproxKoeff: TStringGrid;
    Label2: TLabel;
    STxtRelativError: TStaticText;
    EdAbsError: TEdit;
    EdIndSrcPoint: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure SGEditor1SetEditText(Sender: TObject; ACol, ARow: Integer;
      const Value: String);
    procedure N3Click(Sender: TObject);
    procedure N5Click(Sender: TObject);
    procedure N9Click(Sender: TObject);
    procedure SGEditor1Click(Sender: TObject);
    procedure N10Click(Sender: TObject);
    procedure N11Click(Sender: TObject);
    procedure N12Click(Sender: TObject);
    procedure N13Click(Sender: TObject);
    procedure N14Click(Sender: TObject);
    procedure N17Click(Sender: TObject);
    procedure N16Click(Sender: TObject);
    procedure N15Click(Sender: TObject);
    procedure N18Click(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure N4Click(Sender: TObject);
    procedure STxtCLampTFuncClick(Sender: TObject);
    procedure BtnShowTFuncClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BtnRunAproxClick(Sender: TObject);
    procedure STxtCLamp1AproxClick(Sender: TObject);
    procedure STxtCLamp2AproxClick(Sender: TObject);
    procedure BtnShowAproxClick(Sender: TObject);
    procedure BtnGraphCleanClick(Sender: TObject);
    procedure BtnSaveFuncAsJPEGClick(Sender: TObject);
    procedure N27Click(Sender: TObject);
    procedure N21Click(Sender: TObject);
    procedure N22Click(Sender: TObject);
    procedure N25Click(Sender: TObject);
    procedure N31Click(Sender: TObject);
    procedure N32Click(Sender: TObject);
    procedure BtnReportCleanClick(Sender: TObject);
    procedure BtnSaveReportAsTxtClick(Sender: TObject);
    procedure N34Click(Sender: TObject);
    procedure BtnSaveSpectrAsJPEGClick(Sender: TObject);
    procedure N33Click(Sender: TObject);
    procedure BtnSpectrCleanClick(Sender: TObject);
    procedure N23Click(Sender: TObject);
    procedure BtnSpecrtRefreshClick(Sender: TObject);
    procedure N24Click(Sender: TObject);
    procedure BtnShowBasisClick(Sender: TObject);
    procedure LViewBasisChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure BtnBasisCleanClick(Sender: TObject);
    procedure BtnSaveBasisAsJPEGClick(Sender: TObject);
    procedure STxtLampBasisClick(Sender: TObject);
    procedure BtnShowAllBasisClick(Sender: TObject);
    procedure BtnShowAllPointClick(Sender: TObject);
    procedure CBoxAproxSelectChange(Sender: TObject);
    procedure N35Click(Sender: TObject);
    procedure N6Click(Sender: TObject);
    procedure N30Click(Sender: TObject);
    procedure BitBtnExportSpectrClick(Sender: TObject);
  private
    { Private declarations }
    //       (  - )
    procedure RunSpectrExport();
    //    MouseDown    
   procedure MousUpXY(Sender: TObject; Button: TMouseButton;
                      Shift: TShiftState; X, Y: Integer);
  public
    { Public declarations }
  end;

// ==========================================================
//    PROJECT
// ==========================================================

// ==========================================================
//    PROJECT
// ==========================================================

// ==========================================================
//    PROJECT
// ==========================================================
var
  FormMain  : TFormMain;

// ==========================================================
// IMPLEMENTATION BEGIN
// ==========================================================
implementation
{$R *.dfm}

// ==========================================================
//    UNIT
// ==========================================================

// ==========================================================
//    UNIT
// ==========================================================

// ==========================================================
//   UNIT
// ==========================================================
// ==========================================================
//  /  UNIT-
// ==========================================================
// 
procedure TFormMain.FormCreate(Sender: TObject);
begin
   //  UNIT MainData
   InitMainData(CBoxAproxSelect,
                SGEditor1,
                SG01AproxKoeff,
                STxtTermSeries,
                LViewBasis);
   //  UNIT Report01
   InitReport01 (Memo1, StatusBar1.Panels[2]);
   //  UNIT GridEditor01
   InitGridEditor01(FormMain, EdProjectDesc, SGEditor1, STextNeedSort);
   //    UNIT ShowGraph01
   Init1ShowGraph01(PanelFunction, PanelSpectr, PanelBasis);
   //  29.11.2014 -------------
   if Assigned(GraphFuncXY)
   then begin
      //   
      GraphFuncXY.OnMouseUp := MousUpXY;
      GraphFuncXY.Enabled := True;
   end;
   // ----------------------------------
   //    UNIT ShowGraph01
   Init2ShowGraph01(ColorDialog1,
                    STxtCLamp1Aprox,
                    STxtCLamp2Aprox,
                    STxtCLampTFunc,
                    STxtLampBasis,
                    CBoxFuncSScript,
                    CBoxSpectrSScript,
                    LViewBasis);
   //  UNIT AprroxCentr01
   InitAprroxCentr01(FormMain,
                     CBoxAproxSelect,
                     EdAproxMaxInd,
                     STxtTermSeries,
                     SG01AproxKoeff,
                     STxtRelativError,
                     LViewBasis);
   //   ComoBox -     
   RqApproximationVariant := CBoxAproxSelect.ItemIndex;
   //  UNIT ImportDialog01
   OKBottomDlg.InitImportDialog01(OpenDialog1);
end;
// ----------------------------------------------------------
// 
procedure TFormMain.FormDestroy(Sender: TObject);
begin
  CloseShowGraph01();
end;
// ==========================================================
//   ( )
// ==========================================================
// ----------------------------------------------------------
// 29.11.2014
//          
function ArgToInd(ArgX : extended) : integer;
var Ind : integer;
begin
   Result := -1;
   if Length(AbsErrorFuncTAB) < 2 then Exit;
   for Ind := Low(TableFuncionArray) to High(TableFuncionArray)-1
   do begin
     if (ArgX >= TableFuncionArray[Ind].X) and
        (ArgX <  TableFuncionArray[Ind + 1].X)
     then begin
       Result := Ind;
       Exit;
     end;
   end;
end;

// ----------------------------------------------------------
// 29.11.2014
//   MouseDown   
procedure TFormMain.MousUpXY(Sender: TObject; Button: TMouseButton;
                             Shift: TShiftState; X, Y: Integer);
var Ind1, Ind2    : integer;
    Arg           : extended;
begin
  with GraphFuncXY //    
  do begin
     //  X      
     // ArrXY -     
     Ind1 := XPixToArrInd(X, ArrXY);
     Arg  := ArrXY[Ind1].X;   //      
     Ind2 := ArgToInd(Arg );  //     
     //      
     EdIndSrcPoint.Text := IntToStr(Ind2);
     if (Ind2 >= Low(AbsErrorFuncTAB)) and
        (Ind2 <= High(AbsErrorFuncTAB))
     then EdAbsError.Text := FloatToStr(AbsErrorFuncTAB[Ind2].Y)
     else EdAbsError.Text := '';
  end;
end;

// ==========================================================
//      UNIT GridEditor01
// ==========================================================
// ----------------------------------------------------------
//    
// : MaimMenu1 to GridEditor01
procedure TFormMain.N2Click(Sender: TObject);
begin
  MakeNewTableFuncion('     ');
end; {of procedure}
// ----------------------------------------------------------
//  (  )
// : MaimMenu1 to GridEditor01
procedure TFormMain.N3Click(Sender: TObject);
begin
   LoadTableFunctionFomFile(OpenDialog1, SGEditor1);
end; {of procedure}
// ----------------------------------------------------------
//   (  )
// : MaimMenu1 to GridEditor01
procedure TFormMain.N5Click(Sender: TObject);
begin
  SaveAsTableFunctionToFile(SaveDialog1);
end; {of procedure}
// ----------------------------------------------------------
//  (  )
// : MaimMenu1 to GridEditor01
procedure TFormMain.N4Click(Sender: TObject);
begin
  ReSaveTableFunctionToFile();
end; {of procedure}
// ----------------------------------------------------------
// :   GridEditor   
// : SGEditor1 to GridEditor01
procedure TFormMain.SGEditor1SetEditText(Sender: TObject; ACol,
  ARow: Integer; const Value: String);
begin
  StringEditCell(Sender, ACol, ARow,Value);
end; {of procedure}
// ----------------------------------------------------------
//      
// : MaimMenu1 to GridEditor01
procedure TFormMain.N9Click(Sender: TObject);
begin
  InsernDeleteOnePointTF ('I','U',0);
end; {of procedure}
// : PopUpMenuSGEditor to GridEditor01
procedure TFormMain.N11Click(Sender: TObject);
begin
 InsernDeleteOnePointTF ('I','U',0);
end; {of procedure}
// ----------------------------------------------------------
//      
// : MaimMenu1 to GridEditor01
procedure TFormMain.N10Click(Sender: TObject);
begin
 InsernDeleteOnePointTF ('I','D',0);
end;{of procedure}
// : PopUpMenuSGEditor to GridEditor01
procedure TFormMain.N12Click(Sender: TObject);
begin
 InsernDeleteOnePointTF ('I','D',0);
end;{of procedure}
// ----------------------------------------------------------
//   
// : MaimMenu1 to GridEditor01
procedure TFormMain.N14Click(Sender: TObject);
const GridFixRow = 1;
begin
  InsernDeleteOnePointTF ('I','C', SGEditor1.Row - GridFixRow);
end; {of procedure}
// : PopUpMenuSGEditor to GridEditor01
procedure TFormMain.N13Click(Sender: TObject);
const GridFixRow = 1;
begin
  InsernDeleteOnePointTF ('I','C', SGEditor1.Row - GridFixRow);
end; {of procedure}
// ----------------------------------------------------------
//   
// : MaimMenu1 to GridEditor01
procedure TFormMain.N17Click(Sender: TObject);
const GridFixRow = 1;
begin
  InsernDeleteOnePointTF ('D','C', SGEditor1.Row - GridFixRow);
end; {of procedure}
// : PopUpMenuSGEditor to GridEditor01
procedure TFormMain.N16Click(Sender: TObject);
const GridFixRow = 1;
begin
  InsernDeleteOnePointTF ('D','C', SGEditor1.Row - GridFixRow);
end; {of procedure}
// ----------------------------------------------------------
//      TableFuncionArray
// : MaimMenu1 to GridEditor01
procedure TFormMain.N15Click(Sender: TObject);
begin
  XSortTableFuncionArray();
end; {of procedure}
// : PopUpMenuSGEditor to GridEditor01
procedure TFormMain.N18Click(Sender: TObject);
begin
  XSortTableFuncionArray();
end; {of procedure}
// ----------------------------------------------------------
//     (Info only)
procedure TFormMain.SGEditor1Click(Sender: TObject);
begin
  StatusBar1.Panels[0].Text:= ' Ind = ' + IntToStr(SGEditor1.Row-1);
end; {of procedure}

// ==========================================================
//       UNIT ShowGraph01
// ==========================================================
// ----------------------------------------------------------
//       
procedure TFormMain.BtnGraphCleanClick(Sender: TObject);
begin
 FuncGraphClean();
end;
procedure TFormMain.N21Click(Sender: TObject);
begin
 FuncGraphClean();
end;
// ----------------------------------------------------------
//     
procedure TFormMain.STxtCLampTFuncClick(Sender: TObject);
begin
 SetFuncColorDialog(0);
end;
// ----------------------------------------------------------
//       
procedure TFormMain.STxtCLamp1AproxClick(Sender: TObject);
begin
  SetFuncColorDialog(1);
end;
// ----------------------------------------------------------
//       
procedure TFormMain.STxtCLamp2AproxClick(Sender: TObject);
begin
  SetFuncColorDialog(1);
end;
// ----------------------------------------------------------
//    
procedure TFormMain.BtnShowTFuncClick(Sender: TObject);
begin
  TabXYDotPaintToGFunc(TableFuncionArray);
end;
procedure TFormMain.N22Click(Sender: TObject);
begin
  TabXYDotPaintToGFunc(TableFuncionArray);
end;
// ----------------------------------------------------------
//   
procedure TFormMain.BtnShowAproxClick(Sender: TObject);
begin
  ShowDetalAproxFunc(cMaxDetalGraph, LastExecuteMethod, LastExecuteSeries);
end;
procedure TFormMain.N25Click(Sender: TObject);
begin
  ShowDetalAproxFunc(cMaxDetalGraph, LastExecuteMethod, LastExecuteSeries);
end;
// ----------------------------------------------------------
//     JPEG
procedure TFormMain.BtnSaveFuncAsJPEGClick(Sender: TObject);
begin
  SaveSelectGraphicAsJPEG('F',SaveDialog1);
end;
procedure TFormMain.N32Click(Sender: TObject);
begin
  SaveSelectGraphicAsJPEG('F',SaveDialog1);
end;
// ----------------------------------------------------------
//     JPEG
procedure TFormMain.BtnSaveSpectrAsJPEGClick(Sender: TObject);
begin
  SaveSelectGraphicAsJPEG('S',SaveDialog1);
end;
procedure TFormMain.N33Click(Sender: TObject);
begin
  SaveSelectGraphicAsJPEG('S',SaveDialog1);
end;
// ----------------------------------------------------------
//       
procedure TFormMain.BtnSpectrCleanClick(Sender: TObject);
begin
  SpectrGraphClean();
end;
procedure TFormMain.N23Click(Sender: TObject);
begin
  SpectrGraphClean();
end;
// ----------------------------------------------------------
//      
procedure TFormMain.BtnSpecrtRefreshClick(Sender: TObject);
begin
 ShowSpectr(SpectrLineTab, AproximationColor);
end;
procedure TFormMain.N24Click(Sender: TObject);
begin
 ShowSpectr(SpectrLineTab, AproximationColor);
end;
// ==========================================================
//      
// ==========================================================
//-----------------------------------------------------------
//     Basis 
procedure TFormMain.STxtLampBasisClick(Sender: TObject);
begin
 SetBasisColorDialog();
end;
//-----------------------------------------------------------
//    BasisSelectList    ListView
procedure TFormMain.LViewBasisChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  ChangeBasisSelectList (Item);
end;
//-----------------------------------------------------------
//       
procedure TFormMain.BtnBasisCleanClick(Sender: TObject);
begin
 BasisGraphClean();
end;
//-----------------------------------------------------------
//       
//      BASIS.
procedure TFormMain.BtnShowAllPointClick(Sender: TObject);
begin
 TabXYDotPaintToGBasis(TableFuncionArray);
end;
//-----------------------------------------------------------
//     (  BASIS)
//   
procedure TFormMain.BtnShowAllBasisClick(Sender: TObject);
begin
 ShowBasisDetalAproxFunc
    (False, cMaxDetalGraph, LastExecuteMethod, LastExecuteSeries);
end;
//-----------------------------------------------------------
//    (   BASIS)
//    ListView 
procedure TFormMain.BtnShowBasisClick(Sender: TObject);
begin
  ShowBasisDetalAproxFunc
    (True, cMaxDetalGraph, LastExecuteMethod, LastExecuteSeries);
end;
//-----------------------------------------------------------
//   Basis  JPEG
procedure TFormMain.BtnSaveBasisAsJPEGClick(Sender: TObject);
begin
 SaveSelectGraphicAsJPEG('V',SaveDialog1);
end;
// ==========================================================
//     UNIT AprroxCentr01
// ==========================================================
// -----------------------------------------------------------
//    
procedure TFormMain.CBoxAproxSelectChange(Sender: TObject);
begin
   if RqApproximationVariant <> CBoxAproxSelect.ItemIndex
   then begin
      //       
      RqApproximationVariant := CBoxAproxSelect.ItemIndex;
      //    
      CleanAproximationResult();
      //       
      SpectrGraphClean();
      //       
      BasisGraphClean();
   end;
end;
// -----------------------------------------------------------
//   
procedure TFormMain.BtnRunAproxClick(Sender: TObject);
begin
   RunSelectAprox();
end;
procedure TFormMain.N31Click(Sender: TObject);
begin
   RunSelectAprox();
end;
// ==========================================================
//     
// ==========================================================
// -----------------------------------------------------------
//       
procedure TFormMain.N27Click(Sender: TObject);
begin
  ReportClearAndTitulInit();
end;
procedure TFormMain.BtnReportCleanClick(Sender: TObject);
begin
  ReportClearAndTitulInit();
end;
// -----------------------------------------------------------
//     TXT
procedure TFormMain.BtnSaveReportAsTxtClick(Sender: TObject);
begin
 SaveReportAsFileTxt(SaveDialog1);
end;
procedure TFormMain.N34Click(Sender: TObject);
begin
 SaveReportAsFileTxt(SaveDialog1);
end;
// ==========================================================
//       
//  (    2.05 12.07.2011 )
// ==========================================================
//     
procedure SpectrExport (RqFileName : string);
var wList : TStringList;   //  
    Ind   : integer;       //  
    wStr  : string;        //  
begin
    wList := nil;
    try
       wList := TStringList.Create;
       //    
       wStr  := TableFuncionFileName;
       if wStr = ''
       then wStr := 'NoName'
       else wStr := ExtractFileName(wStr);
       wList.Add('//  (Cn, Pn)    : ' + wStr);
       //     
       for Ind := Low(FourierKoeff) to High(FourierKoeff)
       do begin
         //       
         wStr := '  ' + FloatToStr(FourierKoeff[Ind].CKoeff)
               + #09
               + '  ' + FloatToStr(FourierKoeff[Ind].PKoeff);
         wList.Add(wStr);
       end;
       //    
       wList.SaveToFile(RqFileName);
    finally
       if wList <> nil then wList.Free;
    end;
end;
// -----------------------------------------------------------
//       (  - )
procedure TFormMain.RunSpectrExport();
const UExt = '.TXT';
      LExt = '.txt';
var   wFileName : string;
begin
   //     
   SaveDialog1.InitialDir := ExtractFilePath(Application.ExeName);
   //    
   SaveDialog1.Filter := 'Text spectr files (*' + LExt + ')|*' + UExt;
   if SaveDialog1.Execute
   then begin
      wFileName := SaveDialog1.FileName;
      //      
      if UpperCase(ExtractFileExt(wFileName)) <> UExt
      then wFileName := wFileName + LExt;
      //  
      if FileExists(wFileName)
      then begin
         if MessageDlg('   ! '
                      + #13#10
                      + '  : '
                      + ExtractFileName(wFileName),
                      mtWarning, [mbYes, mbNo], 0) = mrYes
         then begin
             //    
             SpectrExport(wFileName);
         end;
      end
      else SpectrExport(wFileName);
  end;
end;
// -----------------------------------------------------------
//      
procedure TFormMain.BitBtnExportSpectrClick(Sender: TObject);
begin
   //       
   if LastExecuteMethod = cmFourier
   then begin
      //      
      RunSpectrExport();
   end
   else MessageDlg('  '
                  + #13#10
                  + '   ...',
                  mtWarning, [mbOk], 0)
end;


// ==========================================================
//      
// ==========================================================
//       
procedure TFormMain.N35Click(Sender: TObject);
begin
 ImportDialog01.OKBottomDlg.ShowModal;
end;
// -----------------------------------------------------------
//    
procedure TFormMain.N30Click(Sender: TObject);
begin
  About.AboutBox.ShowModal;
end;
// ==========================================================
//    
// ==========================================================
//   
procedure TFormMain.N6Click(Sender: TObject);
begin
  FormMain.Close;
end;
// ==========================================================
//                  IMPLEMENTATION END
// ==========================================================
// ==========================================================


end.
